gameOverSong = 'classicDocDeath';
retrySFX = 'gameover/doc/deathEnd';
lossSFXName = "gameover/doc/classicgameOver";
characterName = 'classicDoc';
var _static:CustomShader = new CustomShader('tvStatic');
var retry:FlxSprite = new FlxSprite().loadGraphic("images/stages/doc/retry.png");
var watermark = new FlxSprite(20, 640).loadGraphic(Paths.image("stages/doc/dfearstudios"));

var spider:FlxSprite = new FlxSprite(-660, 35);
spider.frames = Paths.getFrames("characters/spiderguy");
spider.animation.addByPrefix("idle", "idle", 24, true);
spider.animation.addByPrefix("HYA", "right", 12, false);
spider.scale.set(2,2);
spider.updateHitbox();

var time:Float = 0;


function postCreate() {
	camOver = new FlxCamera(0, 0, 960, 720);
	camOver.bgColor = FlxColor.TRANSPARENT;
	FlxG.cameras.add(camOver, false);
	
	retry.alpha = 0.001;
	retry.cameras = [camOver];
	retry.screenCenter();
	retry.antialiasing = true;
	add(retry);
	
	add(spider);
	spider.animation.play("HYA");
	spider.offset.set(-22,-1);
	FlxTween.tween(spider, {x: -270}, 0.4, {startDelay: 0.4, ease: FlxEase.quartIn});
	
	watermark.cameras = [camOver];
	add(watermark);
}

function onEnd(event) {
	FlxG.camera.addShader(_static);
	retry.visible = false;
	
}
function beatHit(cur:Int) {
	retry.scale.set(1,1);
	FlxTween.tween(retry.scale, {x: 0.9, y: 0.9}, 0.42);
	spider.animation.play("idle", true);
	if(cur != 0) return;
	FlxTween.tween(retry, {alpha: 1}, 1.2);
	spider.offset.set(0,0);
}
function update(elapsed)
{
	_static.iTime = time;
	time += elapsed;
}